# Effects of School-based Multicomponent Positive Psychology Interventions on Well-being and Distress in Adolescents: A Systematic Review and Meta-analysis

Claudia Tejada-Gallardo $\mathbb { O } ^ { 1 }$ ● Ana Blasco-Belled $\mathbb { O } ^ { 1 }$ ● Cristina Torrelles-Nadal $\mathbb { O } ^ { 1 }$ ● Carles Alsinet $\mathbb { \oplus } ^ { 1 }$

Received: 8 April 2020 / Accepted: 9 July 2020 / Published online: 18 July 2020   
$\circledcirc$ Springer Science+Business Media, LLC, part of Springer Nature 2020

# Abstract

Multicomponent positive psychology interventions are increasing in the general population but the study of its effectiveness in adolescents is still scarce, especially in the school context. Previous meta-analyses have reported that multicomponent positive psychology interventions increase well-being and reduce distress outcomes. However, the results on these outcomes limit their samples to adult populations. The aim of the current systematic review and metaanalysis is to evaluate and compare the immediate but also long-lasting effects of school-based multicomponent positive psychology interventions aimed at increasing well-being indicators of mental health (i.e., subjective and psychological well-being) and reducing the most common psychological distress indicators (i.e., depression, anxiety, and stress) in adolescents. A total of 9 randomized and non-randomized controlled trials from the searched literature met inclusion criteria for the meta-analysis. The results showed small effects for subjective well-being $( g = 0 . 2 4 )$ , psychological wellbeing $( g = 0 . 2 5 )$ , and depression symptoms $( g = 0 . 2 8 )$ . Removing low-quality studies led to a slight decrease in the effect sizes for subjective well-being and a considerable increase for psychological well-being and depression symptoms. The relevant moderation analyses had an effect on subjective well-being and depression symptoms. The present systematic review and meta-analysis found evidence for the efficacy of school-based multicomponent positive psychology interventions in improving mental health in the short and long-term. Small effects for subjective well-being, psychological well-being, and depression symptoms were identified. Effects for psychological well-being and depression symptoms remained significant over time. In light of our results, education policy-makers and practitioners are encouraged to include positive practices within the schools’ curriculum as effective and easily implemented tools that help to enhance adolescents’ mental health. Further research is needed in order to strengthen the findings about schoolbased multicomponent positive psychology interventions in adolescents.

Keywords Positive psychology $\cdot$ Well-being $\cdot$ Intervention $\cdot$ Multicomponent $\cdot$ School $\cdot$ Meta-analysis

# Introduction

Psychological research and practice have traditionally focused on the treatment of mental illness, ignoring aspects of well-being and positive functioning promotion (Chakhssi et al. 2018). Adolescence is a crucial transitional stage in biological and psychological development (Burger and Samuel 2017), wherein optimal mental health is conceived as the combination of high levels of well-being and few symptoms of mental illness (Keyes 2009; World Health Organization 2004). In contrast to the growing number of evidence-based interventions, which mainly focus on the treatment of mental disorders and the reduction of psychological distress, few studies have examined the contribution that interventions aiming at increasing well-being have in adolescents (Suldo et al. 2014). Given the need for prevention and intervention during the period of adolescence, school-based programs are an increasing and effective method to enhance positive functioning (Freire et al. 2018). In this effort, positive psychology interventions originated as scientifically-based interventions that focus on strengthening positive emotions, thoughts, and behaviors through activities that can be easily implemented in daily routines (Schotanus-Dijkstra et al. 2015), and have proven their usefulness in promoting well-being and reducing distress in the school setting (Waters 2011). Thus, the present study seeks to examine the effects of school-based multicomponent positive psychology interventions on well-being indicators of mental health (i.e., subjective and psychological well-being) and psychological distress indicators (i.e., depression, anxiety, and stress) in adolescents through a systematic review of the existing literature and a metaanalysis.

# School-based Positive Psychology Interventions in Adolescents

Adolescents spend a significant part of their lifetime in the school and therefore this environment plays an important role in their social, emotional, and psychological development (Waters 2011). Psychological distress can appear during adolescence, being the onset of mental health problems such as anxiety and depression symptoms (Paus et al. 2008), which are the later predictors of stress’ levels (Shapero et al. 2013). Taking into account these considerations, schools could serve as a vehicle for the promotion of positive youth development and effective learning (Clonan et al. 2004). Positive education pursues the promotion of positive emotions, positive relationships, and character strengths and, simultaneously, it attempts to foster skills for happiness and well-being in the school context (Bernard and Walton 2011). Positive education comprises educational institutions that teach both the skills of wellbeing and the skills of achievement, mainly throughout the application of school-based positive psychology interventions (Seligman et al. 2009). To date, these interventions have been implemented in isolated classrooms and not as part of the school curriculum. However, to reach a sustained effect, adolescents have to be exposed to positive psychology interventions more constantly and through different high-school years (Waters 2011). Given the need for a positive youth development in schools, it is imperative to foster the introduction of these interventions under the approach of positive education practices (Noble and McGrath 2008). This approach argues that there are five key foundations of well-being (i.e., social and emotional competency, positive emotions, positive relationships, engagement, and sense of meaning and purpose), which are the enabling factors that should be built into positive psychology interventions.

# Prior Research on Positive Psychology Interventions and Multicomponent Positive Psychology Interventions

In contrast to positive psychology interventions, which are single-component interventions that include one or more individual exercises targeting one component of well-being (e.g., gratitude, hope or character strengths) (Froh et al. 2009; Marques et al. 2011; Proctor et al. 2011), multicomponent positive psychology interventions are based on a variety of individual exercises targeting two or more theoretically relevant well-being components that resemble the key elements of positive education and are conducted within an integral program (Seligman 2011, 2018). According to the Synergistic Change Model (Rusk et al. 2017), which poses that targeting multiple domains of positive functioning decreases the risk of relapse and increases the probability of spill-over effects and synergy between activities, multicomponent positive psychology interventions are more likely to provide long-term effects over positive psychology interventions (Rusk et al. 2017).

To understand the scope of multicomponent positive psychology interventions it is necessary to acknowledge the two main theoretical approaches that define well-being: the hedonic and eudaimonic perspectives. The hedonic perspective describes well-being in terms of pleasure maximization and pain avoidance (Ryan and Deci 2001), and subjective well-being has been commonly referred to as the psychological construct affiliated to this conceptualization (Diener 1984). By contrast, the eudaimonic perspective claims the realization of one’s true inner potential and virtue as a pathway to experiencing a meaningful and fulfilling life (Vittersø 2016; Waterman 1993). Under this premise, wellbeing is a relatively sustained experience that requires personal effort to be achieved (Waterman 1993) and involves how one is functioning in response to life’s demands (psychological well-being; Ryff 1989, 1995) and to larger society (social well-being; Keyes 1998). Multicomponent positive psychology interventions are composed of at least two components that target both perspectives of well-being: hedonia and eudaimonia. Nevertheless, studies examining the effectiveness of these interventions applied in the school context in adolescents are limited (Roth et al. 2017), possibly due to the difficulties of introducing schoolbased well-being initiatives in the school curriculum.

In a prior literature review of school-based single component positive psychology interventions, adolescents’ well-being and academic performance was fostered while distress was mitigated through the application of positive interventions (Waters 2011). Despite the increasing popularity of multicomponent positive psychology interventions in the general population and the emergence of positive education as a mechanism to introduce positive interventions in the school context, it comes as surprise that the application and examination of multicomponent positive psychology interventions’ effectiveness has not been previously reviewed in adolescents, but only in adults (Hendriks et al. 2019; Koydemir et al. 2020). As a result, the present study focused on a review of the existing literature on the topic and the subsequent effects of school-based multicomponent positive psychology interventions in adolescents.

# Current Study

In recent years, there has been an increased popularity of studies on positive psychology interventions. While some metaanalyses have demonstrated the efficacy of multicomponent positive psychology interventions in adult samples, no single meta-analysis has investigated the effects of these interventions in adolescents in the school context. To address this gap, the purpose of the present meta-analysis was to examine the immediate but also long-lasting effects of school-based multicomponent positive psychology interventions aimed at increasing well-being and reducing psychological distress symptoms of adolescents aged between 10 and 18 years old.

The first aim was to identify and quantify the efficacy of well-being indicators of mental health (subjective and psychological well-being) as primary outcomes, and psychological distress indicators (depression, anxiety, and stress) as secondary outcomes, since it is necessary to the continued success of the interventions. To note, not all studies included in the current meta-analysis measured aspects of psychological distress, therefore all selected studies included (a) well-being mental health outcomes, but not necessarily (b) psychological distress outcomes. As a secondary aim, moderation analyses were also applied to explore how intervention effects may vary across different groups (i.e., publication year, study design, type of intervention, control group, number of sessions, duration of intervention, quality of the studies, and follow-up measures). Such analyses were used to investigate sources of heterogeneity, which cannot be drawn from the pooled treatment effect estimate. Taken together, the present study attempted to evaluate the effects of school-based multicomponent positive psychology interventions on well-being and distress symptomatology and the features that improve their efficacy in order to establish recommendations for future interventions to implement in school settings.

systematic reviews and meta-analyses (Moher et al. 2015) were followed in the planning, implementation and reporting of the present meta-analysis. This study was registered in PROSPERO (#CRD42019139586), an international prospective register for systematic reviews.

# Search Strategy

A systematic literature search was performed in the PsycINFO, PubMed, and Scopus databases. Another procedure to identify eligible studies was the reference list screening of previous reviews and meta-analyses for additional potentially eligible studies (Ciocanel et al. 2017; Dunning et al. 2018; Taylor et al. 2017; Waters 2011; Weiss et al. 2016). The last run was conducted in July 2019 and it was done by the first and second authors. The search terms used were: positive psychology, well-being, happy, happiness, gratitude, optimism, kindness, strengths, compassion, forgiveness, intervention, prevention, program, promotion, adolescent, teenager, and youth. The search strings were combined according to the databases (see Appendix Table 5).

# Selection of Studies

The inclusion criteria for the selected studies were formulated in accordance with the PICOS approach and the studies were included, based on the following criteria: (1) the focus of the intervention was adolescents (10–18 years old) from the general population, (2) interventions should target at least two components of well-being as part of a program, (3) measures of the intervention should include outcomes of subjective or psychological well-being and could also include secondary outcomes of depression, anxiety, and stress symptoms, (4) school programs were the focus of the interventions, which included all activities delivered in the school setting during school hours, (5) studies were randomized controlled trials and non-randomized controlled trials that used a control condition, and (6) studies were published in peer-reviewed journals without time restrictions. The exclusion criteria were the following: (1) young people from the clinical population, (2) interventions that only targeted one component of well-being, such as gratitude intervention, hope therapy, strength-based approaches and mindfulness-based interventions, (3) studies not providing sufficient data for the analysis of the effect sizes at post-treatment and with comparison groups, (4) studies published in book chapters, theoretical or narrative review papers and dissertations, and (5) articles published in languages other than English or Spanish.

# Methods

The preferred reporting items for systematic review and meta-analysis protocols (PRISMA-P) for the conducting of

# Data Extraction

Two data extractors (CTG and ABB) independently assessed the eligibility of the studies following a standardized procedure. After removal of duplicates, the retrieved articles from the search were screened. First, the title and abstract were screened by two independent reviewers (CTG and ABB). Secondly, the full text was assessed for all eligible studies. In cases where there was a need to discuss further the disagreements over abstracts or the full text, a third researcher (CTN) also took part until a consensus was reached in all the processes. Data extraction templates were used to extract all the data from the included studies. The information extracted was comprised of the following aspects: the source of the study (author, publication, and date), participants’ details (demographic characteristics and sample size of the experimental and control groups), study design (randomized and non-randomized controlled trials), type of intervention (exercises, number of sessions, duration of the intervention, and delivery) and outcomes at pre, post, and follow-up measures (primary and secondary outcome measures—subjective and psychological well-being and depression, anxiety, and stress symptoms respectively). When data on study methods or results were missing, the authors were contacted to request the necessary information to proceed with the analysis.

# Quality Assessment

All the selected studies were assessed for their methodological quality using the newest Cochrane collaboration tool for assessing risk of bias (RoB 2) in randomized controlled trials (Sterne et al. 2019) by the first (CTG) and second author (ABB) independently. The Cochrane collaboration tool was assessed with respect to five domains: (1) bias arising from the randomization process, (2) bias due to deviation from intended interventions, (3) bias due to missing outcome data, (4) bias in measurement of the outcome, and (5) bias in selection of the reported result. The rating consisted of answering (yes, probably yes, probably no, no, and no information) signaling questions that elicited relevant information for the assessment of risk of bias. The responses to the questions guided the final judgment; the study was judged to be at “low risk of bias” for all domains, if all domains were considered to be at low risk, as having “some concerns” if at least one domain was considered to raise some concerns, or at “high risk of bias” if at least one domain was considered to be at high risk of bias (Sterne et al. 2019). When discrepancies between authors’ ratings regarding quality scores occurred, the authors discussed these differences about the article until they agreed on a common score. The same method was used to assess the risk of bias for randomized and non-randomized controlled trials to standardize the tool for both designs as the majority of studies were randomized controlled trials (and only two were non-randomized controlled trials). An inter-rater reliability of 0.98 was found, which represents an almost perfect level of agreement between authors (McHugh 2012).

# Statistical Analyses

Data were analyzed with the program Comprehensive MetaAnalysis (CMA V.3; Borenstein et al. 2013). For each study, means, standard deviations, and sample sizes were extracted to calculate the effect size. Hedges’ $g$ effect size was used to calculate the differences between groups (i.e., multicomponent positive psychology intervention condition and control condition). Standardized effect sizes were calculated from the average score at pre-intervention and the average score at post-intervention from both groups separately and divided by the pooled standard deviations. Hedge’s $g$ measure was used instead of Cohens’ $d$ to calculate the effect sizes because the former is a more accurate measure when sample sizes are small, and when sample sizes are bigger the results for both statistics are roughly equivalent (Cuijpers 2016). In the present study, small and big sample sizes were present, therefore in the calculation of the effect sizes of the different outcomes the instruments that explicitly measured the outcome were used. For subjective well-being and psychological well-being, a pooled effect size was calculated for all the instruments that measure each outcome. In this sense, one effect size was provided for each outcome in the study. The same procedure was applied to the outcomes of depression and anxiety symptoms. Concerning the stress outcome, it was not possible to calculate its effect size due to the lack of studies measuring it. Follow-up effect sizes were calculated, between-group, if there was a minimum of three studies per outcome.

Due to the diversity of the population (i.e., adolescents from different schools and countries), considerable heterogeneity across studies was expected. For this reason, a random-effects model was used (Borenstein et al. 2010), which assumes that effect sizes are sampled from a population of universal effect sizes. Separated meta-analyses were performed for (1) subjective well-being, (2) psychological well-being, (3) depression symptoms, and (4) anxiety symptoms with a confidence interval of $9 5 \%$ and using a two-tailed test. General effect sizes are considered small between 0–0.32, moderate between 0.33–0.55, and large between 0.56–1.2 (Lipsey and Wilson 1993). Forest plots for between-group effect sizes at post-intervention were created for each outcome variable. Heterogeneity of effect sizes was also examined using the Q test and $\mathrm { I } ^ { 2 }$ statistics. The Q test indicates whether there is heterogeneity in the meta-analysis or not—significant values indicate heterogeneity, suggesting that one or more variables moderated the effect size. The $\mathrm { I } ^ { 2 }$ statistics captures the percentage of the variance between the included studies that can be attributed to heterogeneity—a value of $0 \%$ indicates homogeneity, while values of $2 5 \%$ , $50 \%$ , and $75 \%$ indicate low, moderate, and high levels of heterogeneity, respectively (Higgins and Thompson 2002).

![](images/06c5d8dc68f90d9d1def589616fa15c0cc4f74cdc7176eff9a20e6b2571b076a.jpg)  
Fig. 1 Study selection flow diagram

Different subgroup analyses were examined to test the possible moderating effects of the following variables: (1) year of publication: the last five years and older, (2) study design: randomized and non-randomized controlled trials, (3) intervention: multicomponent positive psychology intervention and multicomponent positive psychology intervention combined with another form of intervention, (4) control group: placebo or waitlist, (5) sessions: six sessions or less and more than six sessions, (6) duration: six weeks or less and more than six weeks, (7) quality of studies: high quality, some concerns and low quality, and (8) presence of follow-up: measurement at follow-up and no measurements at follow-up.

Publication bias was assessed through funnel plots, the Egger’s test, Duval and Tweedie’s trim-and-fill procedure, and the fail-safe N. First, funnel plots were created by plotting the overall mean effect size against study size. A symmetric distribution of studies around the effect size indicates the absence of publication bias, whereas an accumulation of studies on one side or another indicates publication bias (Sterne et al. 2008). Second, Egger’s test was used to examine the symmetric distribution of studies around the effect size with a quantitative test. Funnel plot asymmetry was considered if $p { < } 0 . 0 5$ (Egger et al. 1997). Third, Duval and Tweedie’s trim-and-fill procedure was applied. This procedure imputes the effect sizes of missing studies and produces an adjusted effect size accounting for these missing studies (Duval and Tweedie 2000). Finally, the fail-safe $\mathbf { N }$ indicates the number of unpublished nonsignificant studies that would be required to lower the overall effect size below significance (Egger et al. 1997). Findings were considered robust if the fail-safe $\mathrm { ~ N ~ } \geq 5 \mathrm { n } +$ 10, where n is the number of studies (Rosenberg 2005).

# Results

# Study Selection

A total of 11,585 studies were found in the electronic databases: 3275 from PubMed, 3862 from PsycInfo, 4440 from Scopus and 8 from different reference lists. After removal of duplicates, 9735 articles remained for title and abstract screening. In the next phase, 9661 articles were discarded because they did not meet the inclusion criteria and 74 articles remained to be full-text reviewed. Of these, a total of 9 articles were included in the meta-analysis. The PRISMA analysis represents the process of study selection (Fig. 1).

# Description of Studies

The studies included a total of 4898 participants, 2537 in the intervention condition and 2357 in the control condition. The age of participants ranged from 10 to 18 $( \mathbf { M } = 1 3 . 2 7$ , $S D = 1 . 8 5$ ; $54 \%$ female) years old. The 9 studies included in the meta-analysis were targeting multicomponent positive psychology interventions and 2 of them were combined with another technique (acceptance and commitment therapy and positive youth development). Well-being therapy was a technique used in 2 studies and it was identify as a multicomponent positive psychology intervention because it was based on Ryff’s model of psychological well-being (Schotanus-Dijkstra et al. 2015). Seven studies were randomized controlled trials and 2 were non-randomized controlled trials. The delivery mode was group intervention for all the studies. Five control conditions were active control groups (placebo, $n = 4$ ; anxiety-management school protocol, $n = 1$ ) and 4 were non-active control groups (waitlist). The number of sessions varied between 6 and 18 $\mathbf { M } =$ 11.56, $S D = 4 . 5 3$ ). The duration of the program ranged from 4 to 30 weeks $( \mathbf { M } = 1 3 . 4 4$ ; $S D = 9 . 5 8$ ). Six studies reported follow-up effects and the average follow-up time was 6.25 months $( S D = 2 . 7 5$ ) at post-intervention. The main characteristics of the studies are presented in Table 1.

<html><body><table><tr><td>Boniwell (2015)</td><td></td><td>England,UK 164 (12-13 years),50% non-RCT MPPI</td><td></td><td></td><td>Group</td><td>9 weeks (18 sessions)</td><td>Placebo</td><td>1</td><td>SWB: SLSS, MSLSS, PANAS-C</td></tr><tr><td>Burckhardt (2016) Australia</td><td></td><td>267 (15-18 years),50% RCT</td><td></td><td>MPPI+ACT</td><td>Group</td><td>12 weeks (16 sessions)</td><td>Placebo</td><td></td><td>PWB: FS Dep/Anx/Str: DASS-21</td></tr><tr><td>Freire (2018)</td><td>Portugal</td><td>99 (13-17 years),56%non-RCT MPPI + PYD</td><td></td><td></td><td>Group</td><td>8 weeks (8 sessions)</td><td>Placebo</td><td>1</td><td>SWB: SWLS PWB: PWBS-A</td></tr><tr><td>Roth (2017)</td><td>USA</td><td>42 (11-13 years),50%</td><td>RCT</td><td>MPPI</td><td>Group</td><td>10 weeks (10 sessions)</td><td>Waitlist</td><td></td><td>5 and 7 weeks SWB: BMSLSS, SLSS, PANAS-C</td></tr><tr><td>Ruini (2009)</td><td>Italy</td><td>227 (14-16 years), 61% RCT</td><td></td><td>MPPI (WBT)</td><td>Group</td><td>6 weeks (6 sessions)</td><td>Placebo</td><td>6 months</td><td>PWB: PWB Anx: RCMAS, SQ; Dep: SQ</td></tr><tr><td>Shoshani (2014)</td><td>Israel</td><td>1038 (11-14 years), 50,5%</td><td>RCT</td><td>MPPI</td><td>Group</td><td> 30 weeks (15 sessions)</td><td>Waitlist</td><td>6 and 12 months</td><td> SWB: SWLS Anx/Dep: BSI</td></tr><tr><td>Shoshani (2016)</td><td>Israel</td><td>2517 (12-15 years) 50%</td><td>RCT</td><td>MPPI</td><td>Group</td><td> 30 weeks (15 sessions)</td><td>Waitlist</td><td>8 and 12 months</td><td>SWB: SWLS, PANAS</td></tr><tr><td>Suldo (2014)</td><td>USA</td><td>40 (10-12 years old), 62%</td><td>RCT</td><td>MPPI</td><td>Group</td><td>10 weeks (10 sessions)</td><td>Waitlist</td><td>6 months</td><td>SWB:BMSLSS, SLSS, PANAS-C</td></tr><tr><td>Tomba (2010)</td><td>Italy</td><td>162 (mean = 11.41 vears)57%</td><td>RCT</td><td>MPPI (WBT)</td><td>Group</td><td>6 weeks (6 sessions)</td><td>AM</td><td>6 months</td><td>PWB: PWB Anx: RCMAS, SO: Dep: SO</td></tr></table></body></html>

Table 2 Quality assessment of the studies included in the metaanalysis   

<html><body><table><tr><td>Study</td><td>Domain 1</td><td>Domain 2</td><td>Domain 3</td><td>Domain 4</td><td>Domain 5</td><td>Overall score</td></tr><tr><td>Boniwell (2015)</td><td>HR</td><td>SC</td><td>LR</td><td>SC</td><td>LR</td><td>HR</td></tr><tr><td>Burckhardt (2016)</td><td>LR</td><td>LR</td><td>LR</td><td>SC</td><td>LR</td><td>SC</td></tr><tr><td>Freire (2016)</td><td>HR</td><td>LR</td><td>LR</td><td>SC</td><td>SC</td><td>HR</td></tr><tr><td>Roth (2017)</td><td>LR</td><td>LR</td><td>LR</td><td>SC</td><td>LR</td><td>SC</td></tr><tr><td>Ruini (2009)</td><td>LR</td><td>SC</td><td>LR</td><td>LR</td><td>HR</td><td>HR</td></tr><tr><td>Shoshani (2014)</td><td>LR</td><td>LR</td><td>LR</td><td>LR</td><td>LR</td><td>LR</td></tr><tr><td>Shoshani (2016)</td><td>LR</td><td>LR</td><td>LR</td><td>LR</td><td>LR</td><td>LR</td></tr><tr><td>Suldo (2014)</td><td>SC</td><td>LR</td><td>LR</td><td>SC</td><td>SC</td><td>SC</td></tr><tr><td>Tomba (2010)</td><td>LR</td><td>LR</td><td>LR</td><td>SC</td><td>LR</td><td>SC</td></tr></table></body></html>

Domain 1 risk of bias arising from the randomization process, Domain 2 risk of bias due to deviations from the intended interventions (effect of assignment to intervention), Domain 3 risk of bias due to missing outcome data, Domain 4 risk of bias in measurement of the outcome, Domain 5 risk of bias in selection of the reported results, $L R$ low risk, $S C$ some concerns, HR high risk

# Study Measures

The study’s primary outcomes were both subjective wellbeing and psychological well-being. The outcomes classified as subjective well-being were the following: satisfaction with life, positive affect, and student’s life satisfaction. The outcomes classified as psychological well-being were the following: flourishing and psychological well-being domains (i.e., self-efficacy, autonomy, environmental wellbeing, personal growth, positive relationships, purpose in life, and self-acceptance). All studies included at least one measure of each outcome. Concerning secondary outcomes of the meta-analysis, the measures included were depression, anxiety, and stress symptomatology. However, only one study reported stress outcomes and thus analyses were not performed for this outcome. In total, six studies measured subjective well-being, five studies measured psychological well-being, four studies measured depression, and four studies measured anxiety symptoms. Five studies included two measures of subjective well-being (Boniwell et al. 2015; Roth et al. 2017; Shoshani and Steinmetz 2014; Shoshani et al. 2016; Suldo et al. (2014), which were pooled by the authors of the meta-analysis. One study included more than two measures of psychological well-being that were pooled (Tomba et al. 2010), and two studies included two measures of anxiety symptoms that were also pooled (Ruini et al. 2009; Tomba et al. 2010). In these cases, the effect sizes were calculated using the average effect size of various outcomes of each study (Malle 2006; Turner et al. 2006). See Appendix Table 6 for detailed information on the used instruments per outcome.

# Quality Assessment

When a minimum of one domain did not meet the criteria, the study was labeled as being at high risk of bias. When at least one domain was judged to raise some concerns, the study was labeled as having some concerns and when all domains were judged to be at low risk of bias, the study was labeled as being at low risk. Three studies were rated as being at high risk of bias (i.e., low quality), four studies were rated as having some concerns and two studies did meet all the criteria for being rated as low risk of bias (i.e., high quality). The randomization process domain was the most poorly rated due to the non-randomized controlled trials included in the study that were also assessed with the Cochrane collaboration tool for assessing risk of bias (RoB 2). The quality assessment is displayed in Table 2.

# Post-intervention Effects of Multicomponent Positive Psychology Interventions

Post-intervention effects were calculated for the main outcomes (subjective well-being and psychological well-being)

Table 3 Between–group effects   

<html><body><table><tr><td rowspan="2">Outcome measures</td><td rowspan="2">Studies</td><td rowspan="2">Hedges’g</td><td rowspan="2">95% CI</td><td rowspan="2">Z</td><td colspan="2">Heterogeneity</td><td rowspan="2">Fail-safe N</td></tr><tr><td>Q-value</td><td>1</td></tr><tr><td colspan="8">Studies post-intervention</td></tr><tr><td>SWB</td><td>6</td><td>0.24</td><td>(0.11-0.37)</td><td>3.65***</td><td>9.82*</td><td>49.09</td><td>53</td></tr><tr><td>PWB</td><td>5</td><td>0.25</td><td>(-0.01-0.51)</td><td>1.86*</td><td>22.58***</td><td>82.29</td><td>41</td></tr><tr><td>Depression</td><td>4</td><td>0.28</td><td>(0.13-0.43)</td><td>3.69***</td><td>5.64</td><td>46.84</td><td>27</td></tr><tr><td>Anxiety</td><td>4</td><td>0.14</td><td>(0.04-0.24)</td><td>2.96**</td><td>2.17</td><td>0.00</td><td>3</td></tr><tr><td colspan="8">Studies post-intervention excluding low quality studies</td></tr><tr><td>SWB</td><td>4</td><td>0.21</td><td>(0.05-0.37)</td><td>2.59*</td><td>8.09*</td><td>62.91</td><td></td></tr><tr><td>PWB</td><td>4</td><td>0.31</td><td>(-0.03-0.67)</td><td>1.74</td><td>15.93***</td><td>87.45</td><td></td></tr><tr><td>Depression</td><td>3</td><td>0.34</td><td>(0.24-0.44)</td><td>6.56***</td><td>1.01</td><td>0.00</td><td></td></tr><tr><td>Anxiety</td><td>3</td><td>0.15</td><td>(0.05-0.25)</td><td>2.99**</td><td>1.75</td><td>0.00</td><td></td></tr><tr><td colspan="8">Follow-up studies</td></tr><tr><td>SWB</td><td>4</td><td>0.13</td><td>(0.03-0.23)</td><td>2.54*</td><td>4.10</td><td>30.34</td><td></td></tr><tr><td>PWB</td><td>3</td><td>0.44</td><td>(-0.45-1.31)</td><td>1.80*</td><td>87.65***</td><td>97.71</td><td></td></tr><tr><td>Depression</td><td>3</td><td>0.31</td><td>(0.20-0.41)</td><td>5.80***</td><td>1.78</td><td>0.00</td><td></td></tr><tr><td>Anxiety</td><td>3</td><td>0.15</td><td>(0.05-0.26)</td><td>2.99**</td><td>1.74</td><td>0.00</td><td></td></tr><tr><td colspan="8">Follow-up studies excluding low quality studies</td></tr><tr><td>PWB</td><td>2</td><td>0.66</td><td>(-0.39-1.72)</td><td>1.22</td><td>40.16***</td><td>97.51</td><td></td></tr><tr><td>Depression</td><td>2</td><td>0.29</td><td>(0.11-0.47)</td><td>3.24**</td><td>1.51</td><td>34.05</td><td></td></tr><tr><td>Anxiety</td><td>2</td><td>0.21</td><td>(0.10-0.33)</td><td>3.75***</td><td>0.54</td><td>0.00</td><td></td></tr></table></body></html>

PWB psychological well-being, SWB subjective well-being $^ { * } p < 0 . 0 5$ ; $^ { * * } p < 0 . 0 1$ ; $_ { p < 0 . 0 0 1 }$

and for the secondary outcomes (depression and anxiety symptoms). The analysis of effect sizes was done for all the studies and also for all the outcomes excluding low quality studies (i.e., studies rated as being at high risk of bias). Follow-up effects were also calculated for the studies that included a follow-up analysis and for outcomes excluding low quality studies. Results for studies excluding outliers were not calculate since neither of the studies included in the meta-analysis was considered an outlier. The main results are presented in Table 3.

# Post-intervention effects on subjective well-being

For subjective well-being $( n = 6 )$ ) a significant small effect size was observed $( g = 0 . 2 4$ , $9 5 \%$ CI 0.11–0.38, $p = 0 . 0 0 0 \rangle$ at post-intervention. The effect sizes of the studies ranged from 0.08 to 0.69. Heterogeneity analysis revealed a moderate level of heterogeneity $( \mathrm { I } ^ { 2 } = 4 9 . 0 9 $ , $\mathrm { Q } = 9 . 8 2$ , $p < 0 . 0 5 )$ . When low quality studies were excluded, the effect size remained small $\textstyle { \boldsymbol { g } } = 0 . 2 1$ , $9 5 \%$ CI 0.05–0.37, $p { < } 0 . 0 1 )$ and the heterogeneity increased to a higher level $( \mathrm { I } ^ { 2 } = 6 2 . 9 1 $ , $Q = 8 . 0 9$ , $p { < } 0 . 0 4 )$ . The forest plot in Fig. 2 shows the postintervention effect on subjective well-being.

# Post-intervention effects on psychological well-being

For psychological well-being $( n = 5 )$ ) a significant small effect size was observed $( g = 0 . 2 5$ , $9 5 \%$ CI 0.01–0.51, $p <$ 0.05). The effect sizes of the studies ranged from 0.02 to 0.60. Heterogeneity analysis revealed a high level of heterogeneity between studies $( \mathrm { I } ^ { 2 } = 8 2 . 2 9$ , $\mathrm { Q } = 2 2 . 5 8$ , $p =$ 0.000). When low quality studies were excluded, the effect size remained small but was non-significant $\textstyle { g = 0 . 3 1 }$ , $9 5 \%$ $\mathrm { C I } ~ 0 . 0 3  – 0 . 6 7$ , $p < 0 . 1 2 \AA ,$ ) and heterogeneity remained high $( \mathrm { I } ^ { 2 } = 8 7 . 4 5$ , $Q = 1 5 . 9 3$ , $p = 0 . 0 0 0$ ). The forest plot in Fig. 3 shows the post-intervention effect on psychological wellbeing.

# Post-intervention effects on depression symptoms

For depression symptoms $( n = 4 )$ ) a significant small effect size was observed $g = 0 . 2 8$ , $9 5 \%$ CI 0.13–0.43, $p = 0 . 0 0 0 $ ). The effect sizes of the studies ranged from 0.03 to 0.44. Heterogeneity analysis revealed that the level of heterogeneity was non-significant. When low quality studies were excluded, the effect size increased to moderate $( g = 0 . 3 4$ , $9 5 \%$ CI 0.24–0.44, $p = 0 . 0 0 0 \rangle$ and the heterogeneity remained non-significant. The forest plot in Fig. 4 shows the post-intervention effect on depression symptoms.

Fig. 2 Forest plot of post-intervention effect sizes for subjective well-being   
Fig. 3 Forest plot of post-intervention effect sizes for psychological well-being   

<html><body><table><tr><td rowspan="2">Studyname</td><td rowspan="2">Outcome</td><td colspan="8">Statistics for each study</td><td colspan="4">Hedges&#x27;s g and 95% Cl</td></tr><tr><td>Hedges&#x27;s g</td><td>Standard error</td><td>Variance</td><td>Lower limit</td><td>Upper limit</td><td>Z-Value</td><td>p-Value</td><td colspan="4"></td></tr><tr><td>Boniwell</td><td>Combined</td><td>0.354</td><td>0,159</td><td>0.025</td><td>0.042</td><td>0,666</td><td></td><td>2.227</td><td>0.026</td><td></td><td></td><td></td></tr><tr><td>Freire, 2018</td><td>SWB</td><td>0.453</td><td>0,232</td><td>0.054</td><td>-0.002</td><td>0.907</td><td></td><td>1.953</td><td>0.051</td><td></td><td></td><td></td></tr><tr><td>Roth, 2017</td><td>Combined</td><td>0.690</td><td>0.313</td><td>0,098</td><td>0.078</td><td>1.303</td><td></td><td>2.209 0.027</td><td></td><td></td><td></td><td></td></tr><tr><td>Shoshani, 2014</td><td>SWB</td><td>0,082</td><td>0.062</td><td>0,004</td><td>-0.040</td><td>0.204</td><td></td><td>1,319</td><td>0,187</td><td></td><td></td><td></td></tr><tr><td>Shoshani, 2016</td><td>Combined</td><td>0.257</td><td>0.040</td><td>0.002</td><td>0.179</td><td>0.336</td><td></td><td>6,417</td><td>0.000</td><td></td><td>+</td><td></td></tr><tr><td>Suldo,2014</td><td>Combined</td><td>0,280</td><td>0.312</td><td>0.097</td><td>-0.332</td><td>0.892</td><td></td><td>0.898</td><td>0.369</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>0,245</td><td>0.067</td><td>0.005</td><td>0,114</td><td>0.377</td><td></td><td>3.652</td><td>0.000</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>-1.00</td><td>-0,50</td><td>0,00 0.50</td><td>1,00</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>Control</td><td>MPPI intervention</td><td></td></tr></table></body></html>

![](images/2bdb2734eedf7219c455875dfb42bf192df37aa6abaddc514069d1a6e45d4240.jpg)

![](images/275209d268d16377af386caa328638faac223a8d51ff9330921a7b2b956b1d1a.jpg)  
Fig. 4 Forest plot of post-intervention effect sizes for depression symptoms

# Post-intervention effects on anxiety symptoms

For anxiety symptoms $( n = 4 )$ the effect size at postintervention was non-significant. When low quality studies were excluded, the effect size remained non-significant. Heterogeneity analysis revealed that no heterogeneity was found and hence did not require exploration in a subgroup analysis. The forest plot in Fig. 5 shows the postintervention effect on anxiety symptoms.

# Subgroup Analysis

A total of eight moderators were defined in the metaanalysis: year of publication (last five years vs. older), design of the study (randomized vs. non-randomized controlled trials), type of intervention (multicomponent positive psychology intervention vs. multicomponent positive psychology intervention combined with another positive intervention), control group (placebo vs. waitlist), sessions (six or less vs. more than six), duration (six weeks or less vs. more than six weeks), quality of the studies (high, some concerns, and low), and follow-up measures (presence of follow-up vs. no follow-up). These categorical moderators were used in a subgroup analysis to examine the likely contributions in the overall effect sizes at post-intervention.

![](images/eb6fda7c4b8427dcb387c065d01414b2454d151526bb44de40f2bc625ace74a0.jpg)  
Fig. 5 Forest plot of post-intervention effect sizes for anxiety symptoms

Regarding subjective well-being, significant moderating analyses indicated that non-randomized controlled trials showed a significant larger effect size $n = 2$ ; $g = 0 . 3 8$ , $9 5 \%$ CI 0.12–0.64, $p < 0 . 0 0 3 )$ compared to randomized controlled trials $( n = 4 ; ~ g = 0 . 2 1$ , $9 5 \%$ CI 0.05–0.37, $p <$ 0.009). Depending on the type of intervention, moderating effects were also observed: the only study that employed a multicomponent positive psychology intervention combined with another type of positive intervention showed a significant larger effect size $( n = 1$ ; $g = 0 . 4 5$ , $9 5 \%$ CI 0.00–0.90, $p { < } 0 . 0 5 )$ compared to studies with a multicomponent positive psychology intervention exclusively $\lceil n = 5$ ; $g = 0 . 2 3$ , $9 5 \%$ CI 0.09–0.37, $p { < } 0 . 0 0 1$ ). The type of control group also had a significant moderating effect: studies where the control group was a placebo showed larger effects $( n = 3$ ; $g = 0 . 3 8$ , $9 5 \%$ CI 0.12–0.64, $p <$ 0.003) compared to control group studies with waitlist $\mathbf { \bar { \boldsymbol { n } } = }$ 2; $g = 0 . 1 5$ , $9 5 \%$ CI 0.05–0.37, $p { < } 0 . 0 0 9 $ ). The quality of the study was also a significant moderator for subjective well-being: studies with some concerns regarding their quality had a larger effect size $\scriptstyle ( n = 2$ ; $g = 0 . 4 8$ , $9 5 \%$ CI 0.05–0.93, $p { < } 0 . 0 2 )$ compared to low quality studies $( n = 2$ ; $g = 0 . 3 8$ , $9 5 \%$ CI 0.12–0.64, $p { < } 0 . 0 0 3$ ). Finally, the fact of including a follow-up in the study was also considered a moderator: studies with no follow-up showed a significant larger effect size $( n = 2 ; ~ g = 0 . 3 8$ , $9 5 \%$ CI 0.12–0.64, $p { < } 0 . 0 0 3 )$ compared to the studies that included follow-up $\mathrm { \Delta } n = 4$ ; $g = 0 . 2 1$ , $9 5 \%$ CI 0.05–0.37, $p { < } 0 . 0 0 9 )$ .

For depression symptoms significant moderating analyses were found. The study that was published in the last five years had a significant larger effect size $\ln { = } 1$ ; $g =$ 0.44, $9 5 \%$ CI $0 . 2 0 – 0 . 6 9$ , $p = 0 . 0 0 0 \rangle$ ) compared to the older published studies $( n = 3$ ; $g = 0 . 2 3$ , $9 5 \%$ CI 0.05–0.41, $p <$ 0.01). Depending on the type of intervention, moderating effects were also observed: the study that employed a multicomponent positive psychology intervention combined with another type of positive intervention showed a significant larger effect size $( n = 1$ ; $g = 0 . 4 4$ , $9 5 \%$ CI 0.20–0.69, $p = 0 . 0 0 0 \rangle$ compared to studies with a multicomponent positive psychology intervention exclusively $( n = 3$ ; $g = 0 . 2 3$ , $9 5 \%$ CI 0.05–0.41, $p { < } 0 . 0 0 1$ ). The quality of the study was also a significant moderator for subjective well-being. Studies with some concerns regarding quality had larger effects $\scriptstyle ( n = 2$ ; $g = 0 . 3 7$ , $9 5 \%$ CI 0.18–0.56, $p =$ 0.000) compared to high quality studies $( n = 1$ ; $g = 0 . 3 3$ , $9 5 \% \mathrm { C I } 0 . 2 1 \mathrm { - } 0 . 4 5$ , $p = 0 . 0 0 0 \mathrm { \Omega }$ . Finally, the fact of including a follow-up in the study was also considered a moderator: the study with no follow-up analysis showed a significant larger effect size $\ln { = } 1$ ; $g = 0 . 4 4$ , $9 5 \%$ CI 0.20–0.69, $p =$ 0.000) compared to the studies that included follow-up $( n = 3$ ; $g = 0 . 2 3$ , $9 5 \%$ $\textrm { C I } 0 . 0 5  – 0 . 4 1$ , $p { < } 0 . 0 1 $ ). For psychological well-being and anxiety symptoms, any significant results were found. Table 4 shows the results of the subgroup analysis.

# Follow-up Effects

Studies reporting follow-up data of periods ranging from six to twelve months were analyzed. In the present meta-analysis, when multiple follow-ups were present in the same study, only the longest interval was used. Analysis of follow-ups did not show any effect size on subjective wellbeing and anxiety symptoms. The follow-up effect size for psychological well-being was moderate $g = 0 . 4 4$ , $9 5 \%$ $- 0 . 4 5  – 1 . 3 1$ , $p { < } 0 . 0 4 )$ and for depression symptoms was small $( g = 0 . 3 1$ , $9 5 \%$ 0.20–0.41, $p = 0 . 0 0 0 )$ . When low quality studies were excluded, the results for psychological well-being did not show any significant effect. By contrast, the effect size remained small for depression symptoms $( g = 0 . 2 9$ , $9 5 \%$ 0.11–0.47, $p { < } 0 . 0 0 1$ ) and turned out to be significantly small for anxiety symptoms $( g = 0 . 2 1$ , $9 5 \%$ 0.10–0.33, $p { = } 0 . 0 0 0 $ ).

Table 4 Subgroup analysis   

<html><body><table><tr><td>Outcome</td><td>Criteria</td><td>Value</td><td>N</td><td>Hedges&#x27;g</td><td>95% CI</td><td>1</td><td>Z</td></tr><tr><td>SWB</td><td>Year</td><td>Last 5 years</td><td>4</td><td>0.27</td><td>(0.20-0.34)****</td><td>0.00</td><td>7.21</td></tr><tr><td></td><td></td><td>Older</td><td>2</td><td>0.08</td><td>(-0.03-0.20)</td><td>0.00</td><td>1.46</td></tr><tr><td></td><td>Design</td><td>RCT</td><td>4</td><td>0.21</td><td>(0.05-0.37)**</td><td>62.73</td><td>2.06</td></tr><tr><td></td><td></td><td>non-RCT</td><td>2</td><td>0.38</td><td>(0.12-0.64)**</td><td>0.00</td><td>2.94</td></tr><tr><td></td><td>Intervention</td><td>MPPI</td><td>5</td><td>0.23</td><td>(0.09-0.37)**</td><td>54.63</td><td>3.24</td></tr><tr><td></td><td></td><td>MPPI combined</td><td>1</td><td>0.45</td><td>(-0.00-0.90)*</td><td>0.00</td><td>1.95</td></tr><tr><td></td><td>Control</td><td>Placebo</td><td>2</td><td>0.38</td><td>(0.12-0.64)**</td><td>0.00</td><td>2.94</td></tr><tr><td></td><td></td><td>Waitlist</td><td>4</td><td>0.21</td><td>(0.05-0.37)**</td><td>62.73</td><td>2.60</td></tr><tr><td></td><td>Sessions</td><td>≤6 sessions</td><td>1</td><td>1</td><td></td><td>1</td><td>1</td></tr><tr><td></td><td></td><td> &gt;6 sessions</td><td>6</td><td>0.24</td><td>(0.11-0.37)***</td><td>49.09</td><td>3.65</td></tr><tr><td></td><td>Duration</td><td>≤6 weeks</td><td>1</td><td>1</td><td></td><td>1</td><td>1</td></tr><tr><td></td><td></td><td>&gt;6 weeks</td><td>6</td><td>0.24</td><td>(0.11-0.37)***</td><td>49.09</td><td>3.65</td></tr><tr><td></td><td>Quality</td><td>High</td><td>2</td><td>0.17</td><td>(0.00-0.34)*</td><td>0.00</td><td>2.19</td></tr><tr><td></td><td></td><td>Concerns</td><td>2</td><td>0.48</td><td>(0.05-0.93)*</td><td>82.20</td><td>2.19</td></tr><tr><td></td><td></td><td>Low</td><td>2</td><td>0.38</td><td>(0.12-0.64)**</td><td>0.00</td><td>2.94</td></tr><tr><td></td><td>Follow-up</td><td>Yes</td><td>4</td><td>0.21</td><td>(0.05-0.37)**</td><td>62.73</td><td>2.60</td></tr><tr><td>PWB</td><td></td><td>No</td><td>2</td><td>0.38</td><td>(0.12-0.64)**</td><td>0.00</td><td>2.94</td></tr><tr><td></td><td>Year</td><td>Last 5 years</td><td>2</td><td>0.12</td><td>(-0.08-0.34)</td><td>0.00</td><td>1.18</td></tr><tr><td></td><td></td><td>Older</td><td>3</td><td>0.33</td><td>(-0.00-0.67)*</td><td>85.29</td><td>1.91</td></tr><tr><td></td><td>Design</td><td>RCT</td><td>4</td><td>0.29</td><td>(0.00-0.57)*</td><td>84.62</td><td>2.00</td></tr><tr><td></td><td></td><td>non-RCT</td><td>1</td><td>0.02</td><td>(-0.42-0.47)</td><td>0.00</td><td>0.09</td></tr><tr><td></td><td>Intervention</td><td>MPPI</td><td>3</td><td>0.33</td><td>(-0.00-0.67)*</td><td>85.21</td><td>1.91</td></tr><tr><td></td><td></td><td>MPPI combined</td><td>2</td><td>0.12</td><td>(0.08-0.34)</td><td>0.00</td><td>1.87</td></tr><tr><td></td><td>Control</td><td>Placebo</td><td>3</td><td>0.15</td><td>(-0.00-0.32)</td><td>0.00</td><td>1.86</td></tr><tr><td></td><td></td><td>Waitlist</td><td>2</td><td>0.38</td><td>(-0.08-0.85)</td><td>87.66</td><td>1.62</td></tr><tr><td></td><td>Sessions</td><td>≤6 sessions</td><td>2</td><td>0.16</td><td>(-0.03-0.36)</td><td>0.00</td><td>1.66</td></tr><tr><td></td><td></td><td>&gt;6 sessions</td><td>3</td><td>0.29</td><td>(-0.08-1.50)</td><td>86.66</td><td>1.50</td></tr><tr><td></td><td>Duration</td><td>≤6 weeks</td><td>2</td><td>0.16</td><td>(-0.03-0.36)</td><td>0.00</td><td>1.66</td></tr><tr><td></td><td></td><td>&gt;6 weeks</td><td>3</td><td>0.29</td><td>(-0.08-0.68)</td><td>86.66</td><td>1.50</td></tr><tr><td></td><td>Quality</td><td>High</td><td>2</td><td>0.60</td><td>(0.48-0.73)****</td><td>0.00</td><td>9.58</td></tr><tr><td></td><td></td><td>Concerns</td><td>2</td><td>0.14</td><td>(-0.04-0.33)</td><td>0.00</td><td>1.52</td></tr><tr><td></td><td></td><td>Low</td><td>1</td><td>0.15</td><td>(-0.07-0.38)</td><td>0.00</td><td>1.34</td></tr><tr><td></td><td>Follow-up</td><td>Yes</td><td>3</td><td>0.33</td><td>(-0.00-0.67)*</td><td>85.21</td><td>1.91</td></tr><tr><td>Depression</td><td></td><td>No</td><td>2</td><td>0.12</td><td>(-0.08-0.34)</td><td>0.00</td><td>1.18</td></tr><tr><td></td><td>Year</td><td>Last 5 years</td><td>1</td><td>0.44</td><td>(0.20-0.69)***</td><td>0.00</td><td>3.61</td></tr><tr><td></td><td></td><td>Older</td><td>3</td><td>0.23</td><td>(0.05-0.41)*</td><td>50.42</td><td>2.53</td></tr><tr><td></td><td>Design</td><td>RCT</td><td>4</td><td>0.28</td><td>(0.13-0.43)***</td><td>46.68</td><td>3.69</td></tr><tr><td></td><td></td><td>non-RCT</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td></tr><tr><td></td><td>Intervention</td><td>MPPI</td><td>3</td><td>0.23</td><td>(0.05-0.41)*</td><td>50.42</td><td>2.53</td></tr><tr><td></td><td></td><td>MPPI combined</td><td>1</td><td>0.44</td><td>(0.20-0.69)***</td><td>0.00</td><td>3.61</td></tr><tr><td></td><td>Control</td><td>Placebo</td><td>2</td><td>0.24</td><td>(-0.15-0.64)</td><td>80.34</td><td>1.19</td></tr><tr><td></td><td></td><td>Waitlist</td><td>2</td><td>0.32</td><td>(0.20-0.43)***</td><td>0.00</td><td>5.55</td></tr><tr><td></td><td>Sessions</td><td>≤6 sessions</td><td>2</td><td>0.13</td><td>(-0.08-0.35)</td><td>15.21</td><td>1.19</td></tr><tr><td></td><td></td><td>&gt;6 sessions</td><td>2</td><td>0.35</td><td>(0.24-0.46)**</td><td>0.00</td><td>6.38</td></tr><tr><td></td><td>Duration</td><td>≤6 weeks</td><td>2</td><td>0.13</td><td>(-0.08-0.35)</td><td>15.21</td><td>1.19</td></tr><tr><td></td><td></td><td>&gt;6 weeks</td><td>2</td><td>0.35</td><td>(0.24-0.46)***</td><td>0.00</td><td>6.38</td></tr><tr><td></td><td>Quality</td><td>High</td><td>1</td><td>0.33</td><td>(0.21-0.45)***</td><td>0.00</td><td>5.32</td></tr></table></body></html>

Table 4 (continued)   

<html><body><table><tr><td>Outcome</td><td>Criteria</td><td>Value</td><td>N</td><td>Hedges&#x27; g</td><td>95% CI</td><td>1²</td><td>Z</td></tr><tr><td></td><td></td><td>Concerns</td><td>2</td><td>0.37</td><td>(0.18-0.56)***</td><td>0.00</td><td>3.86</td></tr><tr><td></td><td></td><td>Low</td><td>1</td><td>0.03</td><td>(-0.22-0.29)</td><td>0.00</td><td>0.27</td></tr><tr><td></td><td>Follow-up</td><td>Yes</td><td>3</td><td>0.23</td><td>(0.05-0.41)*</td><td>50.42</td><td>2.53</td></tr><tr><td></td><td></td><td>No</td><td>1</td><td>0.44</td><td>(0.20-0.69)***</td><td>0.00</td><td>3.61</td></tr><tr><td>Anxiety</td><td>Year</td><td>Last 5 years</td><td>1</td><td>0.02</td><td>(-0.22-0.25)</td><td>0.00</td><td>0.08</td></tr><tr><td></td><td></td><td>Older</td><td>3</td><td>0.17</td><td>(0.06-0.27)**</td><td>0.00</td><td>3.19</td></tr><tr><td></td><td>Design</td><td>RCT</td><td>4</td><td>0.14</td><td>(0.04-0.24)**</td><td>0.00</td><td>2.96</td></tr><tr><td></td><td></td><td>non-RCT</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td></tr><tr><td></td><td>Intervention</td><td>MPPI</td><td>3</td><td>0.17</td><td>(0.06-0.27)**</td><td>0.00</td><td>3.19</td></tr><tr><td></td><td></td><td>MPPI combined</td><td>1</td><td>0.01</td><td>(-0.22-0.25)</td><td>0.00</td><td>0.08</td></tr><tr><td></td><td>Control</td><td>Placebo</td><td>2</td><td>0.03</td><td>(-0.14-0.21)</td><td>0.00</td><td>0.38</td></tr><tr><td></td><td></td><td>Waitlist</td><td>2</td><td>0.18</td><td>(0.07-0.30)**</td><td>0.00</td><td>3.27</td></tr><tr><td></td><td>Sessions</td><td>≤6 sessions</td><td>2</td><td>0.11</td><td>(-0.08-0.31)</td><td>0.00</td><td>1.17</td></tr><tr><td></td><td></td><td>&gt;6 sessions</td><td>2</td><td>0.13</td><td>(-0.03-0.29)</td><td>40.61</td><td>1.56</td></tr><tr><td></td><td>Duration</td><td>≤6 weeks</td><td>2</td><td>0.11</td><td>(-0.08-0.31)</td><td>0.00</td><td>1.17</td></tr><tr><td></td><td></td><td>&gt;6 weeks</td><td>2</td><td>0.13</td><td>(-0.03-0.29)</td><td>40.61</td><td>1.56</td></tr><tr><td></td><td>Quality</td><td>High</td><td>3</td><td>0.15</td><td>(0.05-0.25)**</td><td>0.00</td><td>2.99</td></tr><tr><td></td><td></td><td>Concerns</td><td>1</td><td>0.06</td><td>(-0.19-0.32)</td><td>0.00</td><td>0.47</td></tr><tr><td></td><td></td><td>Low</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td></tr><tr><td></td><td>Follow-up</td><td>Yes</td><td>3</td><td>0.17</td><td>(0.06-0.27)**</td><td>0.00</td><td>3.19</td></tr><tr><td></td><td></td><td>No</td><td>1</td><td>0.01</td><td>(-0.22-0.25)</td><td>0.00</td><td>0.08</td></tr></table></body></html>

MPPI multicomponent positive psychology intervention, PWB psychological well-being, RCT randomized controlled trial, non-RCT nonrandomized controlled trial, SWB subjective well-being $^ { * } p < 0 . 0 5$ ; $^ { * * } p < 0 . 0 1$ ; $_ { p < 0 . 0 0 1 }$

# Publication Bias

The funnel plot is an approach used to assess publication bias. Symmetry in the funnel plot indicates that the publications are representative, whereas asymmetry indicates that publication bias is likely to be present in the metaanalysis. In the current study, the funnel plot for each analyzed outcome (subjective well-being, psychological well-being, depression, and anxiety) was somewhat asymmetrical. However, the funnel plot is a subjective method and therefore cannot be relied on exclusively in the case of this result. Thus, the fail-safe $_ \mathrm { N }$ test was also conducted, which revealed that 53 studies for subjective well-being, 41 studies for psychological well-being, 27 studies for depression symptoms, and 3 studies for anxiety symptoms were needed to nullify the significant effect at $\mathrm { p } > 0 . 0 5$ . The Egger’s regression intercept test was also used and the results were only significant for psychological wellbeing $( - 4 . 7 6 , \ \mathrm { t } = 4 . 7 4$ , $\mathrm { d f } = 3$ , $p { < } 0 . 0 1 $ ), reporting nonsignificant results for subjective well-being $( 0 . 8 4 , \ \mathrm { \ t = }$ 0.94, $\mathrm { d f } = 4$ , $p < 0 . 4 0 $ ), depression symptoms $( - 1 . 1 8 , \mathrm { t } =$ 0.56, df $= ~ 2$ , $p < 0 . 6 2 $ , and anxiety symptoms $( - 1 . 1 8$ , $\mathbf { t } = 1 . 0 7$ , df $= 2$ , $p < 0 . 3 9 _ { , }$ ). Finally, Duval and Tweedie’s trim-and-fill method was also tested and possible missing studies were imputed to observe potential changes on the effect sizes. For psychological well-being $( g = 0 . 2 9$ , $9 5 \%$ $\mathrm { C I } = 0 . 0 5 \ – 0 . 5 2$ ) and anxiety symptoms $( g = 0 . 1 6$ , $9 5 \%$ $\mathrm { C I } = 0 . 0 7 \mathrm { - } 0 . 2 6$ ) the effect sizes increased, for subjective well-being decreased $( g = 0 . 1 8$ , $9 5 \%$ $\mathrm { C I } = 0 . 0 5 { - 0 . 3 1 }$ ) and for depression symptoms remained the same $\zeta = 0 . 2 8$ , $9 5 \%$ $\mathrm { C I } = 0 . 1 3  – 0 . 4 3$ ). Importantly, the studies included in the meta-analysis, and specifically on each outcome, are not many in order to consider the results potentially significant. Thus, it is likely that missing publications might have affected the results of the present meta-analysis.

# Discussion

Despite the increasing popularity of multicomponent positive psychology interventions in the general population and the emergence of positive education as a mechanism to introduce positive interventions in the schools, the effectiveness of multicomponent positive psychology interventions has not been previously examined in adolescents. To address this gap, the present study investigated the effects of school-based multicomponent positive psychology interventions on well-being (subjective and psychological) and psychological distress symptoms (depression, anxiety, and stress) in adolescents through a meta-analysis. Results indicated that school-based multicomponent positive psychology interventions enhanced subjective and psychological well-being and reduced depression symptoms but not anxiety. Multicomponent positive psychology interventions can increase adolescent’s mental health in the short and long term, hence, education policy-makers and practitioners are encouraged to implement these interventions within the schools’ curriculum, especially in combination with other evidence-based positive interventions, in efforts to provide adolescent with effective tools that ensure their mental health in school.

# Efficacy of Multicomponent Positive Psychology Interventions on Mental Health in Adolescents

The current meta-analysis showed that school-based multicomponent positive psychology interventions in adolescents yielded to increases in subjective well-being $( g =$ 0.24) and psychological well-being $( g = 0 . 2 5 )$ ) and reductions in symptoms of depression $( g = 0 . 2 8 )$ , in accordance with research on adults (Hendriks et al. 2019; Koydemir et al. 2020). Although the effects were small, this suggests that multicomponent positive psychology interventions are an effective strategy to boost well-being in the school context. A possible explanation for the small effects would be that adolescents’ well-being tend to decrease from early to late adolescence (González-Carrasco et al. 2017). A remarkable finding about the efficacy of multicomponent positive psychology interventions is related to the long-term effects found for psychological well-being and depression symptoms: on the one hand, the effects on these outcomes increased from the short to the long term, which contrasts with previous meta-analyses about positive interventions in adults (Bolier et al. 2013; Chakhssi et al. 2018). On the other hand, the effects on subjective well-being were larger in the short-term (just after the intervention) but decreased in the long run, similar to research on adults (Bolier et al. 2013; Hendriks et al. 2019).

According to the hedonic and eudaimonic traditions of well-being, multicomponent positive psychology interventions may have an immediate impact during and right after the intervention is conducted, raising the levels of emotional well-being. Using positive practices that target the key elements of positive education (social and emotional competency, positive emotions, positive relationships, engagement, and sense of meaning and purpose) can entail a pleasant experience for adolescents. While this sense of subjective well-being dissipates over time, a deeper and more sustained sense of meaning and fulfillment is reinforced at follow-up. The fact that adolescents tend to seek many small and momentary pleasures but also have life objectives to accomplish (González-Carrasco et al. 2019) may contribute to explain why multicomponent positive psychology interventions provide both short-term and longterm gains.

The promotion of mental health (and also education) is captured by the 2030 Agenda for Sustainable Development Goals (UN General Assembly. 2015), an international agreement to ensure 17 global challenges for sustainable development. Depression is considered as a common indicator of mental illness (Keyes 2002) characterized by anhedonia (low subjective well-being) and aspects of individual and social malfunctioning (low psychological wellbeing) (American Psychiatric Association. 2013), and it has become a paramount concern in mental health and societal progress given the high rates of people affected in recent years (World Health Organization 2017). More specifically, depression symptoms affect negatively the daily functioning of adolescents (Derdikman-Eiron et al. 2011) and they have been associated with poorer social relationships and academic outcomes, substance abuse, and increased risk of suicide (Beesdo et al. 2009; Birmaher et al. 1996). In light of this, researchers and practitioners are called to provide accessible tools to mitigate this issue that might thus be of societal advantage, and the present study found empirical evidence to support the notion that multicomponent positive psychology interventions are an effective long-term strategy to reduce depressive symptomatology among adolescents.

# Which Characteristics Can Make Multicomponent Positive Psychology Interventions More Beneficial?

Subgroup analysis revealed that the characteristics of the intervention could lead to effective contributions of the multicomponent positive psychology interventions on subjective well-being and depression symptoms. The main features of these interventions included year of publication, study design, type of intervention, control group, quality of studies, and measurement of follow-up. For depression symptoms, the fact that studies published over the last five years were more effective suggests that interventions might evolve and adapt over time to be more effective. The study design was considered as another significant moderator. The non-randomization of participants for the intervention or control group was observed as a more effective process than the randomization of participants for subjective well-being outcomes. This can be explained by the fact that in nonrandomized controlled trials it is easier to control study characteristics (e.g., allocation sequence generation or allocation sequence concealment [Sterne et al. 2019]), which may lead to more (pre)fabricated or beneficial results than randomized controlled trials. Also, in many cases, peer journals preferred the publication of studies with favorable (i.e., significant) results rather than unfavorable (i.e., non-significant) results—this is known as the “file drawer problem” (Dalton et al. 2012).

The type of intervention was a significant moderator for subjective well-being and depression symptoms. When multicomponent positive psychology interventions were combined with another type of positive intervention, the results turned out to be more effective. This combination increases the probability of merging complementary approaches (Burckhardt et al. 2016) and therefore providing and covering a wider range of intervention goals. The control group used in the studies turned out to be a significant moderator for subjective well-being and depression symptoms. In studies where the control group was a placebo, the effect was larger than studies where the control group was in the waitlist. The fact that in psychosocial interventions the control group engaged in other activities, despite being unrelated to the intervention, is considered more valid than relying on the classical design of the waitlist control group (Popp and Schneider 2015). In addition, the quality of studies also had a significant moderating effect on subjective well-being and depression symptoms. In line with a previous meta-analysis (Bolier et al. 2013), for subjective well-being studies with some concerns regarding quality showed larger effects compared to studies with low and high quality. For depression symptoms, it was found the same pattern; however, previous meta-analysis with adults (Chakhssi et al. 2018; Hendriks et al. 2019) showed contradictory results, which might have been caused as a result of the different tools used to assess risk of bias in the different meta-analytic reviews. Finally, significant differences in the effects of the follow-up moderator for subjective well-being and depression symptoms were found. Studies in which follow-up was not examined had larger effects than studies including follow-up measures. As stated previously, this may be related to the assumption that studies with non-significant results are less likely to be published (Sterne et al. 2019). When follow-up was tested, the effectiveness of interventions might be lowered since the peak of effectiveness normally happens right after the intervention. The intervention effects from previous meta-analyses in adults (Bolier et al. 2013; Hendriks et al. 2019) on subjective wellbeing are likely to be reduced over time, thus the results unsurprisingly suggest that positive interventions targeting subjective well-being may only increase momentary wellbeing in adolescents.

# Limitations

Although the current systematic review and meta-analysis addressed some gaps in the literature, the findings must be understood within the confines of its limitations. First, caution is warranted when interpreting the results of the study due to the small number of studies included in the analysis of each outcome and subgroups. For this reason, future studies of school-based multicomponent positive psychology interventions in adolescents are needed to draw firmer conclusions on the efficacy of these interventions. Second, regarding the quality of the studies included in the meta-analysis, it creates a sample with only two studies being rated as low risk of bias. This aspect highlights the importance of considering the assessment of the quality of studies in meta-analytic reviews to be aware of possible limitations of the findings. Third, one of the outcomes of the study (stress) could not be analyzed since there was a lack of studies reporting the stress’ effects. Fourth, the inclusion criteria (e.g., adolescent population, intervention in the school setting, articles from peer-reviewed journals, or articles in English or Spanish) were very restrictive and results should be interpreted in light of the chosen features. Lastly, the study only included studies published in peerreviewed journals and the possibility to omit unpublished results or studies with null findings is present.

The benefits of school-based multicomponent positive psychology interventions in adolescents are evident; however, the studies presented few limitations to discuss. Schools programs are implemented with time restrictions because they are not commonly integrated in the school curriculum but rather handled and implemented by external professionals. Future programs should be implemented by school teachers or school psychologists previously trained, which might enable to introduce the program in schools and through different years. Furthermore, the combination of a multicomponent positive psychology intervention with another evidence-based positive intervention resulted more effective than the single application of a multicomponent positive psychology intervention. Among the reviewed studies, only 2 used the combination of both interventions. Additionally, the number of participants in some studies was weakly powered (i.e., less than 50 participants) and therefore lacked predictive value, which might be translated into exaggerated effects (Button et al. 2013). It is important to highlight that an optimal sample size is required to yield representative results. Finally, all studies included some risk of bias, suggesting that a rigorous methodology and reporting should be followed to increase the quality of studies. The main issue is the lack of information provided by the studies – for instance, many studies lacked information regarding the allocation sequence of participants, session attendance, and the blinding of the assessor to intervention status. This issue should be addressed in the context of journal publication and advocates for more highquality studies that provide all information needed to allow a doable assessment of research quality.

# Implications

# Conclusion

Overall, school-based multicomponent positive psychology interventions aiming at increasing well-being and reducing depression symptoms in adolescents were effective. Ensuring mental health and education are paramount to the Sustainable Development Goals, since mental illness can indeed be a risk factor of education attainment. Providing adolescents with low-cost, easily-delivered tools that promote their mental health and optimal development are key to ensure health and education goals. This meta-analysis showed that multicomponent positive psychology interventions can offer plausible resources to meet these goals: in the short-run, these interventions can help to maximize pleasant experiences in the school context that may also benefit adolescents’ academic performance. In the long-run, they can strengthen the psychological functioning of adolescents and provide them with a sense of meaning and fulfillment. The present findings encourage to introduce multicomponent positive psychology interventions in the school curriculum for building up psychological resources and mitigating the most common societal burden identified worldwide – depression symptomatology.

Based on moderator analysis, we would recommend professionals to implement multicomponent positive psychology interventions in conjunction with other evidencebased positive interventions that enhance well-being, and researchers to preferentially include a placebo control group. Education policy-makers and practitioners are potentially called to exert a relevant role in the application and guidance of positive practices that, in the end, might facilitate the learning process and academic performance of adolescents. As the continued willingness from professionals working with adolescents for the incorporation of the positive education premises in the schools to develop both positive youth functioning and effective learning, education policies should consider the introduction of positive practices like multicomponent positive psychology interventions in the school’s curriculum to enhance the well-being of adolescents and reduce their psychological distress. In line with the abovementioned considerations, teaching both the skills of wellbeing and the skills of achievement will be associated with greater academic achievement and engagement of adolescents in the school context (Datu 2018). Still, it is necessary to establish rigorous methodological approaches to lead to higher-quality studies in the field of positive psychology interventions, such as using randomized controlled trials and follow-up measurements to increase the quality of studies and reduce publication bias. The present study presents evidence on the efficacy of multicomponent positive psychology interventions, proposes following rigorous methodological approaches, and exposes new gaps in the conceptualization of these interventions in the school context.

The effectiveness of multicomponent positive psychology interventions in adolescents’ school-based settings was, to date, not systematically evaluated. This meta-analysis addressed this gap by synthesizing the efficacy of these interventions on subjective and psychological well-being, and symptoms of depression, anxiety, and stress. Results demonstrated that multicomponent positive psychology interventions can be effective in improving subjective and psychological well-being and reducing depression symptoms in adolescents. No effects were found for symptoms of anxiety, while effects on stress could not be analyzed due to lack of studies. The effects on psychological wellbeing and depression symptoms remained significant in the long-term, posing that multicomponent positive psychology interventions offer an opportunity to ensure mental health during adolescents’ development in schools. Academic policies and education practitioners should consider the inclusion of these interventions within the school curriculum to promote adolescents’ mental health and optimal development.

Acknowledgements We would like to thank Jorge Moya and Jaume March for their contributions to earlier versions of this manuscript.

Authors' Contributions C.T.G. conceived of the study, participated in the initial literature search, the evaluation of quality of studies, conducted the preliminary statistical analysis and wrote the first draft of the manuscript; A.B.B. advised the design, participating in the identification of relevant studies, the evaluation of quality of studies, interpretation of the study findings and helped to draft the manuscript; C.T.N. participated in the literature search, data extraction and statistical analysis; C.A. contributed to the conceptualization of the study, interpretation of the findings and oversaw study execution. All authors read and approved the final manuscript.

Data Sharing and Declaration The datasets generated and/or analyzed during the current study are not publicly available but are available from the corresponding author on reasonable request.

# Compliance with Ethical Standards

Conflict of Interest The authors declare that they have no conflict of interest.

Ethical Approval The current manuscript used published studies as the sole data source and did not involve any other data collection or direct interactions with human participants. As such, seeking approval from a human subjects’ review committee is irrelevant.

Informed Consent This research did not involve any data collection or direct interaction with participants and therefore informed consent was not obtained.

Publisher’s note Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional affiliations.

# Appendix: Table 5

Table 5 Strings of the search

: ((“positive psych\*”[Title/Abstract] OR “well-being”[Title/ PUBMEDAbstract] OR wellbeing[Title/Abstract] OR happy[Title/Abstract] OR happiness[Title/Abstract] OR gratitude[Title/Abstract] OR optimism[Title/ Abstract] OR kindness[Title/Abstract] OR strengths[Title/Abstract] OR compassion[Title/Abstract] OR forgiveness[Title/Abstract])) AND (intervention\*[Title/Abstract] OR prevention\*[Title/Abstract] OR program\* [Title/Abstract] OR promotion[Title/Abstract])) AND (adolescent\*[Title/ Abstract] OR youth[Title/Abstract] OR teen\*[Title/Abstract]) (filter: English, Spanish) AB (“positive psych\*“ OR “well-being” OR wellbeing OR PSYCINFO:happy OR happiness OR gratitude OR optimism OR kindness OR strengths OR compassion OR forgiveness) AND AB (intervention\* OR prevention\* OR program\* OR promotion) AND AB (adolescent\* OR teenager\* OR youth OR teen\*) and TI (“positive psych\*“ OR “well-being” OR wellbeing OR happy OR happiness OR gratitude OR optimism OR kindness OR strengths OR compassion OR forgiveness) AND TI (intervention\* OR prevention\* OR program\* OR promotion) AND TI (adolescent\* OR teenager\* OR youth OR teen\*) (filter: academic journals, English, Spanish) (TITLE-ABS-KEY (“positive psych\*“ OR “well-being” OR wellbeing SCOPUS:OR happy OR happiness OR gratitude OR optimism OR kindness OR strengths OR compassion OR forgiveness) AND TITLE-ABS KEY (intervention\* OR prevention\* OR program\* OR promotion) AND TITLE-ABS- KEY (adolescent\* OR youth OR teen\*)) AND DOCTYPE (ar) AND (LIMIT-TO (SUBJAREA, “PSYC”) OR LIMIT-TO (SUBJAREA, “SOCI”)) AND (LIMIT-TO (LANGUAGE, “English”) OR LIMIT-TO (LANGUAGE, “Spanish”))

# Appendix: Table 6

: BMSLSS: The Brief Multidimensional   
Subjective well-beingStudent’s Life Satisfaction Scale; MSLSS: Multidimensional   
Students’ Life Satisfaction Scale; PANAS-C: Positive and Negative   
Affect Schedule for Children; SLSS: Students’ Life Satisfaction   
Scale; SWLS: Satisfaction with Life Scale   
: FS: Flourishing Scale; PWB:   
Psychological well-beingPsychological Well-Being; PWBS-A: Psychological Well-Being   
Scale for Adolescents   
: BSI: Brief Symptoms Inventory; DASS-21: Depression,   
DepressionAnxiety and Stress Scale; SQ: Kellner’s Symptom Questionnaire   
: BSI: Brief Symptoms Inventory; DASS-21: Depression,   
AnxietyAnxiety and Stress Scale; RCMAS: Revised Children Manifest   
Anxiety Scale; SQ: Kellner’s Symptom Questionnaire   
: DASS-21: Depression, Anxiety and Stress Scale

# References

American Psychiatric Association. (2013). Diagnostic and statistical manual of mental disorders. Washington, D.C.: American Psychiatric Association.   
Beesdo, K., Knappe, S., & Pine, D. S. (2009). Anxiety and anxiety disorders in children and adolescents: developmental issues and implications for DSM-V. Psychiatric Clinics of North America, 32(3), 483–524. https://doi.org/10.1016/j.psc.2009.06.002.   
Bernard, M. E., & Walton, K. (2011). The effect of you can do it! Education in six schools on student perceptions of well-being, teaching-learning and relationships. The Journal of Student Wellbeing, 5(1), 22. https://doi.org/10.21913/jsw.v5i1.679.   
Birmaher, B., Ryan, N. D., Williamson, D. E., Brent, D. A., Kaufman, J., Dahl, R. E., & Nelson, B. (1996). Childhood and adolescent depression: a review of the past 10 years. Part I. Journal of the American Academy of Child and Adolescent Psychiatry, 35(11), 1427–1439. https://doi.org/10.1097/00004583-199611000- 00011.   
Bolier, L., Haverman, M., Westerhof, G. J., Riper, H., Smit, F., & Bohlmeijer, E. (2013). Positive psychology interventions: a metaanalysis of randomized controlled studies. BMC Public Health, 13(1). https://doi.org/10.1186/1471-2458-13-119.   
\*Boniwell, I., Osin, E. N., & Martinez, C. (2015). Teaching happiness at school: non-randomised controlled mixed-methods feasibility study on the effectiveness of Personal well-being lessons. Journal of Positive. Psychology, 11(1), 85–98. https://doi.org/10.1080/ 17439760.2015.1025422.   
Borenstein, M., Hedges, L., Higgins, J., & Rothstein, H. (2013). Comprehensive meta-analysis version 3.0. Englewood, NJ: Biostat.   
Borenstein, M., Hedges, L. V., Higgins, J. P. T., & Rothstein, H. R. (2010). A basic introduction to fixed-effect and random-effects models for meta-analysis. Research Synthesis Methods, 1(2), 97–111. https://doi.org/10.1002/jrsm.12.   
\*Burckhardt, R., Manicavasagar, V., Batterham, P. J., & Hadzi-Pavlovic, D. (2016). A randomized controlled trial of strong minds: a school-based mental health program combining acceptance and commitment therapy and positive psychology. Journal of School Psychology, 57, 41–52. https://doi.org/10.1016/j.jsp.2016.05.008.   
Burger, K., & Samuel, R. (2017). The role of perceived stress and selffeficacy in young people’s life satisfaction: a longitudinal study. Journal of Youth and Adolescence, 46(1), 78–90. https://doi.org/ 10.1007/s10964-016-0608-x.   
Button, K. S., Ioannidis, J. P. A., Mokrysz, C., Nosek, B. A., Flint, J., Robinson, E. S. J., & Munafò, M. R. (2013). Power failure: why small sample size undermines the reliability of neuroscience. Nature Reviews Neuroscience, 14(5), 365–376. https://doi.org/10. 1038/nrn3475.   
Chakhssi, F., Kraiss, J. T., Sommers-Spijkerman, M., & Bohlmeijer, E. T. (2018). The effect of positive psychology interventions on well-being and distress in clinical samples with psychiatric or somatic disorders: a systematic review and meta-analysis. BMC Psychiatry, 18(1), 1–17. https://doi.org/10.1186/s12888-018- 1739-2.   
Ciocanel, O., Power, K., Eriksen, A., & Gillings, K. (2017). Effectiveness of positive youth development interventions: a metaanalysis of randomized controlled trials. Journal of Youth and Adolescence, 46(3), 483–504. https://doi.org/10.1007/s10964- 016-0555-6.   
Clonan, S. M., Chafouleas, S. M., McDougal, J. L., & Riley-Tillman, T. C. (2004). Positive psychology goes to school: are we there yet? Psychology in the Schools, 41(1), 101–110. https://doi.org/ 10.1002/pits.10142.   
Cuijpers, P. (2016). Meta-analysis in mental health: a practical guide. Amsterdam, The Netherland: Pim Cuijpers Uitgeverij.   
Dalton, D. R., Aguinis, H., Dalton, C. M., Bosco, F. A., & Pierce, C. A. (2012). Revisiting the file drawer problem in meta-analysis: an assessment of published and nonpublished correlation matrices. Personnel Psychology, 65(2), 221–249. https://doi.org/10.1111/j. 1744-6570.2012.01243.x.   
Datu, J. A. D. (2018). Flourishing is associated with higher academic achievement and engagement in filipino undergraduate and high school students. Journal of Happiness Studies, 19(1), 27–39. https://doi.org/10.1007/s10902-016-9805-2.   
Derdikman-Eiron, R., Indredavik, M. S., Bratberg, G. H., Taraldsen, G., Bakken, I. J., & Colton, M. (2011). Gender differences in subjective well-being, self-esteem and psychosocial functioning in adolescents with symptoms of anxiety and depression: findings from the Nord-Trøndelag health study. Scandinavian Journal of Psychology, 52(3), 261–267. https://doi.org/10.1111/j.1467- 9450.2010.00859.x.   
Diener, E. (1984). Subjective well-being. Psychological Bulletin, 95 (3), 542–575. https://doi.org/10.1037/0033-2909.95.3.542.   
Dunning, D. L., Griffiths, K., Kuyken, W., Crane, C., Foulkes, L., Parker, J., & Dalgleish, T. (2018). Research review: The effects of mindfulness-based interventions on cognition and mental health in children and adolescents – a meta-analysis of randomized controlled trials. Journal of Child Psychology and Psychiatry and Allied Disciplines. https://doi.org/10.1111/jcpp. 12980.   
Duval, S., & Tweedie, R. (2000). Trim and fill: a simple funnel-plotbased method of testing and adjusting for publication bias in meta-analysis. Biometrics, 56(2), 455–463. https://doi.org/10. 1111/j.0006-341X.2000.00455.x.   
Egger, M., Smith, G. D., Schneider, M., & Minder, C. (1997). Bias in meta-analysis detected by a simple, graphical test measures of funnel plot asymmetry. BMJ, 315(7109), 629–634. https://doi. org/10.1136/bmj.315.7109.629.   
\*Freire, T., Lima, I., Teixeira, A., Araújo, M. R., & Machado, A. (2018). Challenge to be+. A group intervention program to promote the positive development of adolescents. Children and Youth Services Review, 87, 173–185. https://doi.org/10.1016/j. childyouth.2018.02.035.   
Froh, J. J., Kashdan, T. B., Ozimkowski, K. M., & Miller, N. (2009). Who benefits the most from a gratitude intervention in children and adolescents? Examining positive affect as a moderator. The Journal of Positive Psychology, 4(5), 408–422. https://doi.org/10. 1080/17439760902992464.   
González-Carrasco, M., Casas, F., Viñas, F., Malo, S., Gras, M. E., & Bedin, L. (2017). What leads subjective well-being to change throughout adolescence? An exploration of potential factors. Child Indicators Research, 10(1), 33–53. https://doi.org/10.1007/ s12187-015-9359-6.   
González-Carrasco, M., Vaqué, C., Malo, S., Crous, G., Casas, F., & Figuer, C. (2019). A Qualitative longitudinal study on the wellbeing of children and adolescents. Child Indicators Research, 12 (2), 479–499. https://doi.org/10.1007/s12187-018-9534-7.   
Hendriks, T., Schotanus-Dijkstra, M., Hassankhan, A., de Jong, J., & Bohlmeijer, E. (2019). The efficacy of multi-component positive psychology interventions: a systematic review and meta-analysis of randomized controlled trials. Journal of Happiness Studies. https://doi.org/10.1007/s10902-019-00082-1.   
Higgins, J. P. T., & Thompson, S. G. (2002). Quantifying heterogeneity in a meta-analysis. Statistics in Medicine, 21(11), 1539–1558. https://doi.org/10.1002/sim.1186.   
Keyes, L. M. (1998). Social well-being. Social Psychology Quarterly, 61(2), 121–137. https://doi.org/10.2307/2787065.   
Keyes, L. M. (2002). The mental health continuum: from languishing to flourishing in life. Journal of Health and Social Behavior, 43 (2), 207–222. https://doi.org/10.2307/3090197.   
Keyes, L. M. (2009). The nature and importance of positive mental health in America’s adolescents. In Handbook of Positive Psychology in Schools (pp. 9–23). https://doi.org/10.4324/ 9780203884089-10.   
Koydemir, S., Sökmez, A. B., & Schütz, A. (2020). A meta-analysis of the effectiveness of randomized controlled positive psychological interventions on subjective and psychological well-Being. Applied Research in Quality of Life. https://doi.org/10.1007/ s11482-019-09788-z.   
Lipsey, M. W., & Wilson, D. B. (1993). The efficacy of psychological, educational, and behavioral Tteatment: confirmation from metaanalysis. American Psychologist, 48(12), 1181–1209. https://doi. org/10.1037/0003-066X.48.12.1181.   
Malle, B. F. (2006). Supplemental material for the actor–observer asymmetry in attribution: a (surprising) meta-analysis. Psychological Bulletin, 132(6), 895–919. https://doi.org/10.1037/0033- 2909.132.6.895.supp.   
Marques, S. C., Lopez, S. J., & Pais-Ribeiro, J. L. (2011). Building hope for the future”: A program to foster strengths in middleschool students. Journal of Happiness Studies, 12(1), 139–152. https://doi.org/10.1007/s10902-009-9180-3.   
McHugh, M. L. (2012). Interrater reliability: the kappa statistic. Biochemia Medica, 22(3), 276–282. https://doi.org/10.11613/bm. 2012.031.   
Moher, D., Shamseer, L., Clarke, M., Ghersi, D., Liberati, A., Petticrew, M., & Whitlock, E. (2015). Preferred reporting items for systematic review and meta-analysis protocols (PRISMA-P) 2015 statement. Systematic Reviews, 4(1), 1–9. https://doi.org/10. 1186/2046-4053-4-1.   
Noble, T., & McGrath, H. (2008). The positive educational practices framework: a tool for facilitating the work of educational psychologists in promoting pupil wellbeing. Educational and Child Psychology, 25(2), 119–134.   
Paus, T., Keshavan, M., & Giedd, J. N. (2008). Why do many psychiatric disorders emerge during adolescence? Nature Reviews Neuroscience, 9(12), 947–957. https://doi.org/10.1038/nrn2513.   
Popp, L., & Schneider, S. (2015). Attention placebo control in randomized controlled trials of psychosocial interventions: Theory and practice. Trials, 16(1), 1–3. https://doi.org/10.1186/s13063- 015-0679-0.   
Proctor, C., Tsukayama, E., Wood, A. M., Maltby, J., Eades, J. F., & Linley, P. A. (2011). Strengths Gym: The impact of a character strengths-based intervention on the life satisfaction and wellbeing of adolescents. The Journal of Positive Psychology, 6(5), 377–388. https://doi.org/10.1080/17439760.2011.594079.   
Rosenberg, M. S. (2005). The file-drawer problem revisited: a general weighted method for calculating fail-safe numbers in metaanalysis. Evolution, 59(2), 464–468. https://doi.org/10.1111/j. 0014-3820.2005.tb01004.x.   
\*Roth, R. A., Suldo, S. M., & Ferron, J. M. (2017). Improving middle school students’ subjective well-being: efficacy of a multicomponent positive psychology intervention targeting small groups of youth. School Psychology Review, 46(1), 21–41. https://doi.org/10.17105/10.17105/spr46-1.21-41.   
\*Ruini, C., Ottolini, F., Tomba, E., Belaise, C., Albieri, E., Visani, D., & Fava, G. A. (2009). School intervention for promoting psychological well-being in adolescence. Journal of Behavior Therapy and Experimental Psychiatry, 40(4), 522–532. https:// doi.org/10.1016/j.jbtep.2009.07.002.   
Rusk, R. D., Vella-Brodrick, D. A., & Waters, L. (2017). A complex dynamic systems approach to lasting positive change: The Synergistic Change Model. The Journal of Positive Psychology, 13(4), 406–418. https://doi.org/10.1080/17439760.2017. 1291853.   
Ryan, R. M., & Deci, E. L. (2001). On happiness and human potentials: a review of research on hedonic and eudaimonic well-being. Annual Review of Psychology, 52(1), 141–166. https://doi.org/10. 1146/annurev.psych.52.1.141.   
Ryff, C. D. (1989). Happiness is everything, or is it? Explorations on the meaning of psychological well-being. Journal of Personality and Social Psychology, 57(6), 1069–1081. https://doi.org/10. 1037/0022-3514.57.6.1069.   
Ryff, C. D. (1995). Psychological well-being in adult life. Current Directions in Psychological Science, 4(4), 99–104.   
Schotanus-Dijkstra, M., Drossaert, C. H., Pieterse, M. E., Walburg, J. A., & Bohlmeijer, E. T. (2015). Efficacy of a multicomponent positive psychology self-help intervention: study protocol of a randomized controlled trial. JMIR Research Protocols, 4(3), 1–16. https://doi.org/10.2196/resprot.4162.   
Seligman, M. (2011). Flourish: a visionary new understanding of happiness and well-being. New York, NY: Simon & Schuster.   
Seligman, M. (2018). PERMA and the building blocks of well-being. Journal of Positive. Psychology, 13(4), 333–335. https://doi.org/ 10.1080/17439760.2018.1437466.   
Seligman, M., Ernst, R. M., Gillham, J., Reivich, K., & Linkins, M. (2009). Positive education: positive psychology and classroom interventions. Oxford Review of Education, 35(3), 293–311. https://doi.org/10.1080/03054980902934563.   
Shapero, B. G., Hankin, B. L., & Barrocas, A. L. (2013). Stress generation and exposure in a multi-wave study of adolescents: transactional processes and sex differences. Journal of Social and Clinical Psychology, 32(9), 989–1012. https://doi.org/10.1521/jscp.2013.32.9.989.   
\*Shoshani, A., & Steinmetz, S. (2014). Positive psychology at school: a School-based intervention to promote adolescents’ mental health and well-being. Journal of Happiness Studies, 15(6), 1289–1311. https://doi.org/10.1007/s10902-013-9476-1.   
\*Shoshani, A., Steinmetz, S., & Kanat-Maymon, Y. (2016). Effects of the Maytiv positive psychology school program on early adolescents’ well-being, engagement, and achievement. Journal of School Psychology, 57, 73–92. https://doi.org/10.1016/j.jsp.2016.05.003.   
Sterne, J. A. C., Savović, J., Page, M. J., Elbers, R. G., Blencowe, N. S., Boutron, I., … Higgins, J. P. T. (2019). RoB 2: a revised tool for assessing risk of bias in randomised trials. The BMJ, 366. https://doi.org/10.1136/bmj.l4898.   
Sterne, J. A., Egger, M., & Moher, D. (2008). Addressing reporting biases. Cochrane Handbook for Systematic Reviews of Interventions. (pp. 297–333). Chichester, UK: John Wiley & Sons, Ltd. https://doi.org/10.1002/9780470712184.ch10.   
\*Suldo, S. M., Savage, J. A., & Mercer, S. H. (2014). Increasing middle school students’ life satisfaction: efficacy of a positive psychology group intervention. Journal of Happiness Studies, 15 (1), 19–42. https://doi.org/10.1007/s10902-013-9414-2.   
Taylor, R. D., Oberle, E., Durlak, J. A., & Weissberg, R. P. (2017). Promoting positive youth development through school‐based social and emotional learning interventions: a meta‐analysis of follow‐up effects. Child Development, 88(4), 1156–1171. https:// doi.org/10.1111/cdev.12864.   
\*Tomba, E., Belaise, C., Ottolini, F., Ruini, C., Bravi, A., Albieri, E., & Fava, G. A. (2010). Differential effects of well-being promoting and anxiety-management strategies in a non-clinical school setting. Journal of Anxiety Disorders, 24(3), 326–333. https://doi.org/10.1016/j.janxdis.2010.01.005.   
Turner, Herbert, M. I., & Bernard, R. M. (2006). Calculating and synthesizing effect sizes. Contemporary Issues in Communication Science and Disorders, 33, 42–55. https://doi.org/10.1044/cicsd_33_s_42.   
UN General Assembly. (2015). Transforming our world: The 2030 agenda for sustainable development (A/RES/70/1). United Nations.   
Vittersø, J. (2016). The most important idea in the world: an introduction. In Handbook of Eudaimonic Well-Being (pp. 1–24). Cham: Springer International Publishing. https://doi.org/10.1007/ 978-3-319-42445-3_1.   
Waterman, A. S. (1993). Two conceptions of happiness: contrasts of personal expressiveness (eudaimonia) and hedonic enjoyment. Journal of Personality and Social Psychology, 64(4), 678–691. https://doi.org/10.1037/0022-3514.64.4.678.   
Waters, L. (2011). A review of school-based positive psychology interventions. The Australian Educational and Developmental Psychologist, 28(2), 75–90. https://doi.org/10.1375/aedp.28. 2.75.   
Weiss, L. A., Westerhof, G. J., & Bohlmeijer, E. T. (2016). Can we increase psychological well-being? The effects of interventions on psychological well-being: a meta-analysis of randomized controlled trials. PLoS ONE, 11(6). https://doi.org/10.1371/journa l.pone.0158092.   
World Health Organization (2004). Promoting Mental Health: Concepts, emerging evidence and practice. Summary report Geneva. Geneva.   
World Health Organization (2017). Depression and other common mental disorders global health etimates. Geneva.

Claudia Tejada-Gallardo is a PhD student at the University of Lleida, Spain. She has a master of science in psychology from the University of Maastricht, Holland. She is also a professor of social psychology at the University of Lleida, Spain. Her major research interests are adolescent’s well-being, youth at risk, prevention and intervention approaches.

Ana Blasco-Belled is a post-doctoral researcher of the University of Lleida, Spain. She obtained her PhD in social psychology with international mention from the University of Lleida, Spain. Her research interests concern the study of well-being of adults and adolescents and the social dynamics of happiness.

Cristina Torrelles-Nadal is Lecturer in the Department of Psychology, University of Lleida, Spain. She received her PhD in Psychopedagogy, with international mention from the University of Lleida, Spain. Her research interests include well-being of adults and adolescents, gratitude, teamwork, happiness, optimism, emotional intelligence and prevention and intervention approaches.

Carles Alsinet is a social psychology professor and director of the Social Innovation Chair (SIC) at the University of Lleida, Spain. He received his PhD in psychology from the University of Lleida, Spain. The topics of his research are well-being, quality of life and social health of adults and adolescents. As a social consultant, he’s currently developing intervention programs based on self-centered approaches to increase people’s well-being.